// Hiển thị/hide loading overlay khi submit form đăng nhập
function showLoginLoading() {
    let overlay = document.getElementById('LoadingOverlay');
    if (!overlay) {
        overlay = document.createElement('div');
        overlay.id = 'LoadingOverlay';
        overlay.style.position = 'fixed';
        overlay.style.top = '0';
        overlay.style.left = '0';
        overlay.style.width = '100vw';
        overlay.style.height = '100vh';
        overlay.style.background = 'rgba(0,0,0,0.25)';
        overlay.style.zIndex = '2000';
        overlay.style.display = 'flex';
        overlay.style.alignItems = 'center';
        overlay.style.justifyContent = 'center';
        overlay.innerHTML = '<div style="background: #fff; padding: 32px 48px; border-radius: 8px; box-shadow: 0 2px 8px rgba(0,0,0,0.15); display: flex; flex-direction: column; align-items: center;">' +
            '<div class="spinner-border text-primary" style="width: 3rem; height: 3rem;" role="status"></div>' +
            '<div style="margin-top: 16px; font-size: 1.2rem; color: #333;">Đang xử lý...</div>' +
            '</div>';
        document.body.appendChild(overlay);
    }
    overlay.style.display = 'flex';
}

function hideLoginLoading() {
    const overlay = document.getElementById('LoadingOverlay');
    if (overlay) overlay.style.display = 'none';
}

// Gắn vào form đăng nhập
window.addEventListener('DOMContentLoaded', function() {
    const form = document.querySelector('form[action="/Account/Login"]');
    if (form) {
        form.addEventListener('submit', function(e) {
            showLoginLoading();
        });
    }
});
